# Source Code File 1. Code for Pearson correlation tests and ANOVA tests in Figure 3 and Figure 5


library(sjPlot)
library(ggplot2)
library(dplyr)
library(ggpubr)
library(reshape2)
library("Hmisc") # Correlation analysis
library(corrplot) # Correlation plot
library(ape)
library(geiger)
library(nlme)
library(phytools)
library(rsq)


# Code for pearson correlation analysis
data <- read.csv("FinalCHC&Desiccation50Spp.csv")
str(data)
data$logDesiccation <- log10(data$Desiccation)
data$weight_ug <- data$weightmg * 1000
data_male <- data[data$Sex == "Male",]
data_female <- data[data$Sex == "Female",]

# Desiccation & body weight for males and females

cor.test(data_male$logDesiccation, data_male$weight_ug,method = "pearson")
cor.test(data_female$logDesiccation, data_female$weight_ug,method = "pearson")

# Total CHC quantity & body weight (ug) for males and females
data_male$logTotalCHC_ug <- log(data_male$Total_ng/1000)
data_male$weight_ug <- data_male$weightmg*1000
cor.test(data_male$logTotalCHC_ug, data_male$weight_ug,method = "pearson")
cor.test(data_female$logTotalCHC_ug, data_female$weight_ug,method = "pearson")

# glm on desiccation & CHCperBodyWeight for males and females
cor.test(data_male$logDesiccation, data_male$PercentBW,method = "pearson")
cor.test(data_female$logDesiccation, data_female$PercentBW,method = "pearson")
# mbCHC correlation with desiccation resistance 
## Correlation analysis between each of mbCHCs and desiccation resistance 

cor.test(data_female$logDesiccation, data_female$mb30,method = "pearson")

cor.test(data_female$logDesiccation, data_female$mb32,method = "pearson")

cor.test(data_female$logDesiccation, data_female$mb28,method = "pearson")

cor.test(data_female$logDesiccation, data_female$mb26,method = "pearson")

cor.test(data_male$logDesiccation, data_male$mb26,method = "pearson")

cor.test(data_male$logDesiccation, data_male$mb30,method = "pearson")

cor.test(data_male$logDesiccation, data_male$mb32,method = "pearson")

cor.test(data_male$logDesiccation, data_male$mb28,method = "pearson")





# Code for all coating experiments on attP40 and CHC- flies

library(ggplot2)
library(nlme)
library(dplyr)
library(ggpubr)
library(tidyverse)
library(broom)
library(AICcmodavg)
library(multcomp)
# Load data
attP40Coating_mbCHC <- read.csv("Desiccation_mbCHC_attP40.csv")
attP40alkane <- read.csv("Desiccation_nalkanes_attP40.csv")
nakedFlyCoating27C <- read.csv("Desiccation_coated_CHC-.csv")

pj <- position_jitterdodge(jitter.width=0.2, seed=9,
                           jitter.height = 0,
                           dodge.width = 0.75)


# Code for Stat and Figure on attP40 coating with mbCHCs
attP40Coating_mbCHC$Trt <- factor(attP40Coating_mbCHC$Trt, 
                                  levels = c("Control","2MeC26","2MeC28","2MeC30"))
attP40Coating_mbCHC_male <- attP40Coating_mbCHC[attP40Coating_mbCHC$Sex == "Male",]

ggplot(attP40Coating_mbCHC_male, aes(x = Trt, y = Desiccation)) + 
  geom_boxplot(outlier.shape = NA,lwd =.5) +
  geom_jitter(width = .2,size=1) +
  labs(y = "Desiccation resistance (h)", x = "Treatments") +
  ylim(0,25) +
  theme_classic()+
  ggtitle("Male")+
  theme(axis.text=element_text(size=10,color = "black",face="bold"),
        axis.title=element_text(size=10,face="bold"))+ 
  theme( axis.line = element_line(colour = "black", 
                                  size = 1, linetype = "solid"))+
  theme(axis.ticks = element_line(colour = "black",size = 1)) +
  theme(axis.ticks.length=unit(.3, "cm"))
ggsave("attP40Coating_mbCHC_male.png",width = 3, height = 5, dpi = 300, units = "in", device='png')
# stats for male
res_aov_attP40Coating_mbCHC__male <- aov(Desiccation ~ Trt,
                                         data = attP40Coating_mbCHC_male
)
summary(res_aov_attP40Coating_mbCHC_male)
post_test_attP40Coating_mbCHC_male <- glht(res_aov_attP40Coating_mbCHC_male,
                                           linfct = mcp(Trt = "Tukey")
)
summary(post_test_attP40Coating_mbCHC_male)


attP40Coating_mbCHC_female <- attP40Coating_mbCHC[attP40Coating_mbCHC$Sex == "Female",]
ggplot(attP40Coating_mbCHC_female, aes(x = Trt, y = Desiccation)) + 
  geom_boxplot(outlier.shape = NA,lwd =.5) +
  geom_jitter(width = .2,size=1) +
  labs(y = "Desiccation resistance (h)", x = "Treatments") +
  ylim(0,25) + ggtitle("Female")+
  theme_classic()+
  theme(axis.text=element_text(size=10,color = "black",face="bold"),
        axis.title=element_text(size=10,face="bold"))+ 
  theme( axis.line = element_line(colour = "black", 
                                  size = 1, linetype = "solid"))+
  theme(axis.ticks = element_line(colour = "black",size = 1)) +
  theme(axis.ticks.length=unit(.3, "cm"))
ggsave("attP40Coating_mbCHC_female.png",width = 3, height = 5, dpi = 300, units = "in", device='png')
# stats for female
res_aov_attP40Coating_mbCHC_female <- aov(Desiccation ~ Trt,
                                          data = attP40Coating_mbCHC_female
)
summary(res_aov_attP40Coating_mbCHC_female)
post_test_attP40Coating_mbCHC_female<- glht(res_aov_attP40Coating_mbCHC_female,
                                            linfct = mcp(Trt = "Tukey")
)
summary(post_test_attP40Coating_mbCHC_female)


# Correlation analysis on mbCHC length and desiccation resistance 

attP40Coating <- attP40Coating_mbCHC
attP40Coating$Trt2 <- with(attP40Coating,
                           ifelse(Trt == "2MeC26", "1",
                                  ifelse(Trt == "2MeC28", "2",
                                         ifelse(Trt == "2MeC30", "3","NA"))))

## test pearson correlation between mbCHC and desiccation resistance in coating experiments. 
### Include Sham here. 
attP40Coating$Trt2 <- as.numeric(attP40Coating$Trt2)
attP40Coating$DR <- as.numeric(attP40Coating$Desiccation)
attP40Coating$logDR <- log10(attP40Coating$DR)
class(attP40Coating$Trt2)

attP40Coating_female <- attP40Coating[attP40Coating$Sex == "Female",]
attP40Coating_male <- attP40Coating[attP40Coating$Sex == "Male",]

cor.test(attP40Coating_female$logDR, attP40Coating_female$Trt2,method = "pearson")
cor.test(attP40Coating_male$logDR, attP40Coating_male$Trt2,method = "pearson")

out_attP40Coating_female <- glm(logDR ~ Trt2,data = attP40Coating_female)
summary(out_attP40Coating_female)

out_attP40Coating_male <- glm(logDR ~ Trt2,data = attP40Coating_male)
summary(out_attP40Coating_male)


### not include Sham in the analysis.  
attP40CoatingNoSham <- attP40Coating %>%
  filter(Trt != "Control")

attP40CoatingNoSham_female <- attP40CoatingNoSham[attP40CoatingNoSham$Sex == "Female",]
attP40CoatingNoSham_male <- attP40CoatingNoSham[attP40CoatingNoSham$Sex == "Male",]

cor.test(attP40CoatingNoSham_female$logDR, attP40CoatingNoSham_female$Trt2,method = "pearson")
cor.test(attP40CoatingNoSham_male$logDR, attP40CoatingNoSham_male$Trt2,method = "pearson")


out_attP40CoatingNoSham_female_NoSham <- glm(logDR ~ Trt2,data = attP40CoatingNoSham_female)
summary(out_attP40CoatingNoSham_female_NoSham)

out_attP40CoatingNoSham_male_NoSham <- glm(logDR ~ Trt2,data = attP40CoatingNoSham_male)
summary(out_attP40CoatingNoSham_male_NoSham)


# Make the figure.
p_attP40CoatingNoSham_female_NoSham <- plot_model(out_attP40CoatingNoSham_female_NoSham,type = "pred",
                                                  terms = c("Trt2"),
                                                  show.data = TRUE,line.size = 1,jitter = 0.05)
p_attP40CoatingNoSham_female_NoSham <-p_attP40CoatingNoSham_female_NoSham + theme_bw() +  
  theme(panel.grid =element_blank()) +
  labs(y="log(Desiccation Resistance)",x= "Coated mbCHCs",title = "") + 
  theme(axis.title.y = element_text(size = 12, color = "black"),
        axis.title.x = element_text(size = 12, color = "black"),
        axis.text.x = element_text(size = 12, color = "black"),
        axis.text.y =element_text(size = 12,color = "black") ) 
p_attP40CoatingNoSham_female_NoSham
ggsave(filename = "p_attP40CoatingNoSham_female_NoSham.png", plot = p_attP40CoatingNoSham_female_NoSham, device="png",dpi = 600, width = 8, height = 8, units = 'cm')

p_attP40CoatingNoSham_male_NoSham <- plot_model(out_attP40CoatingNoSham_male_NoSham,type = "pred",
                                                terms = c("Trt2"),
                                                show.data = TRUE,line.size = 1,jitter = 0.05)
p_attP40CoatingNoSham_male_NoSham <-p_attP40CoatingNoSham_male_NoSham + theme_bw() +  
  theme(panel.grid =element_blank()) +
  labs(y="log(Desiccation Resistance)",x= "Coated mbCHCs",title = "") + 
  theme(axis.title.y = element_text(size = 12, color = "black"),
        axis.title.x = element_text(size = 12, color = "black"),
        axis.text.x = element_text(size = 12, color = "black"),
        axis.text.y =element_text(size = 12,color = "black") ) 
p_attP40CoatingNoSham_male_NoSham
ggsave(filename = "p_attP40CoatingNoSham_male_NoSham.png", plot = p_attP40CoatingNoSham_female_NoSham, device="png",dpi = 600, width = 8, height = 8, units = 'cm')






# Code for attP40 flies & coating n-alkane experiment

attP40alkane$Trt <- factor(attP40alkane$Trt, 
                           levels = c("Sham","C23","C25","C27","C29","C31"))
attP40alkane_Female <- attP40alkane[attP40alkane$Sex == "Female",]
attP40alkane_Male <- attP40alkane[attP40alkane$Sex == "Male",]
pj <- position_jitterdodge(jitter.width=0.2, seed=9,
                           jitter.height = 0,
                           dodge.width = 0.75)

library(tidyverse)
library(gapminder)

attP40alkane %>% 
  ggplot(aes(x = Trt, y = Desiccation,fill=Sex)) +
  geom_boxplot() + geom_jitter(width=0.1,alpha=0.2) 

attP40alkane_Female %>% 
  ggplot(aes(x = Trt, y = Desiccation)) +
  geom_boxplot() + geom_jitter(width=0.1,alpha=0.2) 

attP40alkane_Male %>% 
  ggplot(aes(x = Trt, y = Desiccation)) +
  geom_boxplot() + geom_jitter(width=0.1,alpha=0.2) 




ggplot(nakedFlyCoating_Female, aes(x = Conc, y = DR,fill=mbCHC)) + 
  geom_boxplot(outlier.shape = NA,lwd =.5) +
  geom_jitter(width = .2,size=1) +
  labs(y = "Desiccation resistance (h)", x = " ") +
  ylim(0,5) +
  theme_classic()+
  theme(axis.text=element_text(size=12,color = "black",face="bold"),
        axis.title=element_text(size=12,face="bold"))+ 
  theme( axis.line = element_line(colour = "black", 
                                  size = 1, linetype = "solid"))+
  theme(axis.ticks = element_line(colour = "black",size = 1)) +
  theme(axis.ticks.length=unit(.3, "cm"))

# stats
res_aov_trialCoatingAlkaneFemale <- aov(Desiccation ~ Trt,
                                        data = attP40alkane_Female
)
summary(res_aov_trialCoatingAlkaneFemale)
post_test_trialCoatingAlkaneFemale <- glht(res_aov_trialCoatingAlkaneFemale,
                                           linfct = mcp(Trt = "Tukey")
)
summary(post_test_trialCoatingAlkaneFemale)


res_aov_trialCoatingAlkaneMale <- aov(Desiccation ~ Trt,
                                      data = attP40alkane_Male
)
summary(res_aov_trialCoatingAlkaneMale)
post_test_trialCoatingAlkaneMale <- glht(res_aov_trialCoatingAlkaneMale,
                                         linfct = mcp(Trt = "Tukey")
)
summary(post_test_trialCoatingAlkaneMale)




# Correlation analysis between alkane length & desiccation resistance

attP40alkaneNOSham <- attP40alkane[attP40alkane$Trt %in% c("C23","C25","C27","C29","C31"),]
attP40alkaneNOSham$Trt2 <- with(attP40alkaneNOSham,
                                ifelse(Trt == "C23", "1",
                                       ifelse(Trt == "C25", "2",
                                              ifelse(Trt == "C27", "3",
                                                     ifelse(Trt == "C29", "4",
                                                            ifelse(Trt == "C31", "5","NA"))))))
attP40alkaneNOSham$Trt2 <- as.numeric(attP40alkaneNOSham$Trt2)
attP40alkaneNOSham$Desiccation <- as.numeric(attP40alkaneNOSham$Desiccation)
attP40alkaneNOSham$logDR <- log10(attP40alkaneNOSham$Desiccation)
class(attP40alkaneNOSham$Trt2)
class(attP40alkaneNOSham$logDR)

attP40alkaneNOSham_female <- attP40alkaneNOSham[attP40alkaneNOSham$Sex == "Female",]
attP40alkaneNOSham_male <- attP40alkaneNOSham[attP40alkaneNOSham$Sex == "Male",]

# pearson correlation
cor.test(attP40alkaneNOSham_female$logDR, attP40alkaneNOSham_female$Trt2,method = "pearson")
cor.test(attP40alkaneNOSham_male$logDR, attP40alkaneNOSham_male$Trt2,method = "pearson")

out_attP40alkaneNOSham_female <- glm(logDR ~ Trt2,data = attP40alkaneNOSham_female)
summary(out_attP40alkaneNOSham_female)

out_attP40alkaneNOSham_male <- glm(logDR ~ Trt2,data = attP40alkaneNOSham_male)
summary(out_attP40alkaneNOSham_male)

# Make the figure.
p_attP40alkaneNOSham_female <- plot_model(out_attP40alkaneNOSham_female,type = "pred",
                                          terms = c("Trt2"),
                                          show.data = TRUE,line.size = 1,jitter = 0.05)
p_attP40alkaneNOSham_female <-p_attP40alkaneNOSham_female + theme_bw() +  
  theme(panel.grid =element_blank()) +
  labs(y="log(Desiccation Resistance)",x= "Coated mbCHCs",title = "") + 
  theme(axis.title.y = element_text(size = 12, color = "black"),
        axis.title.x = element_text(size = 12, color = "black"),
        axis.text.x = element_text(size = 12, color = "black"),
        axis.text.y =element_text(size = 12,color = "black") ) 
p_attP40alkaneNOSham_female
ggsave(filename = "p_attP40alkaneNOSham_female.png", plot = p_attP40alkaneNOSham_female, device="png",dpi = 600, width = 8, height = 8, units = 'cm')


p_attP40alkaneNOSham_male <- plot_model(out_attP40alkaneNOSham_male,type = "pred",
                                        terms = c("Trt2"),
                                        show.data = TRUE,line.size = 1,jitter = 0.05)
p_attP40alkaneNOSham_male <-p_attP40alkaneNOSham_male + theme_bw() +  
  theme(panel.grid =element_blank()) +
  labs(y="log(Desiccation Resistance)",x= "Coated mbCHCs",title = "") + 
  theme(axis.title.y = element_text(size = 12, color = "black"),
        axis.title.x = element_text(size = 12, color = "black"),
        axis.text.x = element_text(size = 12, color = "black"),
        axis.text.y =element_text(size = 12,color = "black") ) 
p_attP40alkaneNOSham_male
ggsave(filename = "p_attP40alkaneNOSham_male.png", plot = p_attP40alkaneNOSham_male, device="png",dpi = 600, width = 8, height = 8, units = 'cm')


# Code for naked flies. 

nakedFlyCoating27C$Trt <- factor(nakedFlyCoating27C$Trt, 
                                 levels = c("Sham","mb26","mb28","mb30","C23","C25","C27","C29","C31"))

nakedFlyCoating27C %>% 
  ggplot(aes(x = Trt, y = Desiccation,fill=Sex)) +
  geom_boxplot() + geom_jitter(width=0.1,alpha=0.2) 

nakedFlyCoating27C_female <- nakedFlyCoating27C[nakedFlyCoating27C$Sex == "Female",]

nakedFlyCoating27C_male <- nakedFlyCoating27C[nakedFlyCoating27C$Sex == "Male",]

# Female
ggplot(nakedFlyCoating27C_female, aes(x = Trt, y = Desiccation)) + 
  geom_boxplot(outlier.shape = NA,lwd =1) +
  geom_jitter(width = .2,size=1) +
  labs(y = "Desiccation resistance (h)", x = "Treatments") +
  ylim(0,8) +
  theme_classic()+
  theme(axis.text=element_text(size=12,color = "black",face="bold"),
        axis.title=element_text(size=15,face="bold"))+ 
  theme( axis.line = element_line(colour = "black", 
                                  size = 1, linetype = "solid"))+
  theme(axis.ticks = element_line(colour = "black",size = 1)) +
  theme(axis.ticks.length=unit(.3, "cm")) +
  scale_x_discrete(labels= c(
    "Sham","2MeC26","2MeC28","2MeC30","C23","C25","C27","C29","C31"))
ggsave("NakedFliesCoatingFemale27C.png",width = 8, height = 6, dpi = 300, units = "in", device='png')
# Male
ggplot(nakedFlyCoating27C_male, aes(x = Trt, y = Desiccation)) + 
  geom_boxplot(outlier.shape = NA,lwd =1) +
  geom_jitter(width = .2,size=1) +
  labs(y = "Desiccation resistance (h)", x = "Treatments") +
  ylim(0,8) +
  theme_classic()+
  theme(axis.text=element_text(size=12,color = "black",face="bold"),
        axis.title=element_text(size=15,face="bold"))+ 
  theme( axis.line = element_line(colour = "black", 
                                  size = 1, linetype = "solid"))+
  theme(axis.ticks = element_line(colour = "black",size = 1)) +
  theme(axis.ticks.length=unit(.3, "cm"))+
  scale_x_discrete(labels= c(
    "Sham","2MeC26","2MeC28","2MeC30","C23","C25","C27","C29","C31"))
ggsave("NakedFliesCoatingMale27C.png",width = 8, height = 6, dpi = 300, units = "in", device='png')



# stats
res_aov_nakedFemale27 <- aov(Desiccation ~ Trt,
                             data = nakedFlyCoating27C_female
)
summary(res_aov_nakedFemale27)
library("emmeans") 
pairs(emmeans(res_aov_nakedFemale27,~Trt))


##post_test_nakedFemale27 <- glht(res_aov_nakedFemale27, linfct = mcp(Trt = "Tukey"))

res_aov_nakedMale27 <- aov(Desiccation ~ Trt,
                           data = nakedFlyCoating27C_male
)
summary(res_aov_nakedMale27)
pairs(emmeans(res_aov_nakedMale27,~Trt))
emmeans(res_aov_nakedMale27,~Trt)


## test pearson correlation between mbCHC and desiccation resistance 
#in coating experiments - naked flies at 27C. 

#Add column to rename mbCHC to numbers


nakedFlyCoating27CmbCHC <- nakedFlyCoating27C[nakedFlyCoating27C$Trt %in% c("mb26","mb28","mb30"),]

nakedFlyCoating27CmbCHC$Trt2 <- with(nakedFlyCoating27CmbCHC,
                                     ifelse(Trt == "mb26", "1",
                                            ifelse(Trt == "mb28", "2",
                                                   ifelse(Trt == "mb30", "3","NA"))))

nakedFlyCoating27CmbCHC$Trt2 <- as.numeric(nakedFlyCoating27CmbCHC$Trt2)
nakedFlyCoating27CmbCHC$Desiccation <- as.numeric(nakedFlyCoating27CmbCHC$Desiccation)
nakedFlyCoating27CmbCHC$logDR <- log10(nakedFlyCoating27CmbCHC$Desiccation)
class(nakedFlyCoating27CmbCHC$Trt2)
class(nakedFlyCoating2$DR)
nakedFlyCoating27CmbCHC_female <- nakedFlyCoating27CmbCHC[nakedFlyCoating27CmbCHC$Sex == "Female",]
nakedFlyCoating27CmbCHC_male <- nakedFlyCoating27CmbCHC[nakedFlyCoating27CmbCHC$Sex == "Male",]

# pearson correlation
cor.test(nakedFlyCoating27CmbCHC_female$logDR, nakedFlyCoating27CmbCHC_female$Trt2,method = "pearson")
cor.test(nakedFlyCoating27CmbCHC_male$logDR, nakedFlyCoating27CmbCHC_male$Trt2,method = "pearson")

# plot.
out_nakedFlyCoating27CmbCHC_female <- glm(logDR ~ Trt2,data = nakedFlyCoating27CmbCHC_female)
summary(out_nakedFlyCoating27CmbCHC_female)

out_nakedFlyCoating27CmbCHC_male <- glm(logDR ~ Trt2,data = nakedFlyCoating27CmbCHC_male)
summary(out_nakedFlyCoating27CmbCHC_male)

library(sjPlot)

p_nakedFlyCoating27CmbCHC_female <- plot_model(out_nakedFlyCoating27CmbCHC_female,type = "pred",
                                               terms = c("Trt2"),
                                               show.data = TRUE,line.size = 1,jitter = 0.05)
p_nakedFlyCoating27CmbCHC_female <-p_nakedFlyCoating27CmbCHC_female + theme_bw() +  
  theme(panel.grid =element_blank()) +
  labs(y="log(Desiccation Resistance)",x= "Coated mbCHCs",title = "") + 
  theme(axis.title.y = element_text(size = 12, color = "black"),
        axis.title.x = element_text(size = 12, color = "black"),
        axis.text.x = element_text(size = 12, color = "black"),
        axis.text.y =element_text(size = 12,color = "black") ) 
p_nakedFlyCoating27CmbCHC_female
ggsave(filename = "p_nakedFlyCoating27CmbCHC_female", plot = p_nakedFlyCoating27CmbCHC_female, device="png",dpi = 600, width = 8, height = 8, units = 'cm')

p_nakedFlyCoating27CmbCHC_male <- plot_model(out_nakedFlyCoating27CmbCHC_male,type = "pred",
                                             terms = c("Trt2"),
                                             show.data = TRUE,line.size = 1,jitter = 0.05)
p_nakedFlyCoating27CmbCHC_male <-p_nakedFlyCoating27CmbCHC_male + theme_bw() +  
  theme(panel.grid =element_blank()) +
  labs(y="log(Desiccation Resistance)",x= "Coated mbCHCs",title = "") + 
  theme(axis.title.y = element_text(size = 12, color = "black"),
        axis.title.x = element_text(size = 12, color = "black"),
        axis.text.x = element_text(size = 12, color = "black"),
        axis.text.y =element_text(size = 12,color = "black") ) 
p_nakedFlyCoating27CmbCHC_male
ggsave(filename = "p_nakedFlyCoating27CmbCHC_male.png", plot = p_nakedFlyCoating27CmbCHC_male, device="png",dpi = 600, width = 8, height = 8, units = 'cm')

##### For alkanes

nakedFlyCoating27Cnalkane <- nakedFlyCoating27C[nakedFlyCoating27C$Trt %in% c("C23","C25","C27","C29","C31"),]
nakedFlyCoating27Cnalkane$Trt2 <- with(nakedFlyCoating27Cnalkane,
                                       ifelse(Trt == "C23", "1",
                                              ifelse(Trt == "C25", "2",
                                                     ifelse(Trt == "C27", "3",
                                                            ifelse(Trt == "C29", "4",
                                                                   ifelse(Trt == "C31", "5","NA"))))))
nakedFlyCoating27Cnalkane$Trt2 <- as.numeric(nakedFlyCoating27Cnalkane$Trt2)
nakedFlyCoating27Cnalkane$Desiccation <- as.numeric(nakedFlyCoating27Cnalkane$Desiccation)
nakedFlyCoating27Cnalkane$logDR <- log10(nakedFlyCoating27Cnalkane$Desiccation)
class(nakedFlyCoating27Cnalkane$Trt2)
class(nakedFlyCoating27Cnalkane$logDR)

nakedFlyCoating27Cnalkane_female <- nakedFlyCoating27Cnalkane[nakedFlyCoating27Cnalkane$Sex == "Female",]
nakedFlyCoating27Cnalkane_male <- nakedFlyCoating27Cnalkane[nakedFlyCoating27Cnalkane$Sex == "Male",]

# pearson correlation
cor.test(nakedFlyCoating27Cnalkane_female$logDR, nakedFlyCoating27Cnalkane_female$Trt2,method = "pearson")
cor.test(nakedFlyCoating27Cnalkane_male$logDR, nakedFlyCoating27Cnalkane_male$Trt2,method = "pearson")

out_nakedFlyCoating27Cnalkane_female <- glm(logDR ~ Trt2,data = nakedFlyCoating27Cnalkane_female)
summary(out_nakedFlyCoating27Cnalkane_female)

out_nakedFlyCoating27Cnalkane_male <- glm(logDR ~ Trt2,data = nakedFlyCoating27Cnalkane_male)
summary(out_nakedFlyCoating27Cnalkane_male)

# Make the figure.
p_nakedFlyCoating27Cnalkane_female <- plot_model(out_nakedFlyCoating27Cnalkane_female,type = "pred",
                                                 terms = c("Trt2"),
                                                 show.data = TRUE,line.size = 1,jitter = 0.05)
p_nakedFlyCoating27Cnalkane_female <-p_nakedFlyCoating27Cnalkane_female + theme_bw() +  
  theme(panel.grid =element_blank()) +
  labs(y="log(Desiccation Resistance)",x= "Coated mbCHCs",title = "") + 
  theme(axis.title.y = element_text(size = 12, color = "black"),
        axis.title.x = element_text(size = 12, color = "black"),
        axis.text.x = element_text(size = 12, color = "black"),
        axis.text.y =element_text(size = 12,color = "black") ) 
p_nakedFlyCoating27Cnalkane_female
ggsave(filename = "p_nakedFlyCoating27Cnalkane_female.png", plot = p_nakedFlyCoating27Cnalkane_female, device="png",dpi = 600, width = 8, height = 8, units = 'cm')


p_nakedFlyCoating27Cnalkane_male <- plot_model(out_nakedFlyCoating27Cnalkane_male,type = "pred",
                                               terms = c("Trt2"),
                                               show.data = TRUE,line.size = 1,jitter = 0.05)
p_nakedFlyCoating27Cnalkane_male <-p_nakedFlyCoating27Cnalkane_male + theme_bw() +  
  theme(panel.grid =element_blank()) +
  labs(y="log(Desiccation Resistance)",x= "Coated mbCHCs",title = "") + 
  theme(axis.title.y = element_text(size = 12, color = "black"),
        axis.title.x = element_text(size = 12, color = "black"),
        axis.text.x = element_text(size = 12, color = "black"),
        axis.text.y =element_text(size = 12,color = "black") ) 
p_nakedFlyCoating27Cnalkane_male
ggsave(filename = "p_nakedFlyCoating27Cnalkane_male.png", plot = p_nakedFlyCoating27Cnalkane_male, device="png",dpi = 600, width = 8, height = 8, units = 'cm')

